﻿package com.java24hours;

import java.io.IOException;
import java.nio.file.*;
import javax.swing.*;
 
public class FreeSpacePanel extends JPanel {
    JLabel spaceLabel = new JLabel("Przestrzeń dyskowa: ");
    JLabel space = new JLabel();
        
    public FreeSpacePanel() {
        super();
        add(spaceLabel);
        add(space);
        try {
            setValue();
        } catch (IOException ioe) {
            space.setText("Błąd");
        }
    }
    
    private final void setValue() throws IOException {
        // Określ pulę magazynowania plików.
        Path current = Paths.get("");
        FileStore store = Files.getFileStore(current);
        // Oblicz ilość wolnej przestrzeni magazynowej. 
        long totalSpace = store.getTotalSpace();
        long freeSpace = store.getUsableSpace();
        // Wyraź to w procentach (z dokładnością do dwóch cyfr po przecinku).
        double percent = (double)freeSpace / (double)totalSpace * 100;
        percent = (int)(percent * 100) / (double)100;
        // Ustal tekst etykiety.
        space.setText(freeSpace + " wolnej z " + totalSpace + " ("
            + percent + "%)");
        
     }
}
